package decoratorexample;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.List;

public class LineReader {

    private BufferedReader reader;

    public LineReader(String fileName) {
        try {
            reader = new BufferedReader(new FileReader(fileName));
        } catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void readAllLines(List<String> storage) {
        try {
            String line = reader.readLine();
            while (line != null) {
                storage.add(line);
                line = reader.readLine();
            }
        } catch (IOException e) {
            e.printStackTrace();
        }
    }
}
